#!/usr/bin/python
# coding: UTF-8
# Rec10 TS Recording Tools
# Copyright (C) 2009 Yukikaze
import glob
import os
import time

import configreader
import recdblist
dbpath = str(os.path.dirname(os.path.abspath(__file__))) + "/" + "ch.db"
if __name__ == "__main__":
    recdblist.printutf8("Hello Rec10 Recording Que Search.")
def search_b25(path):
    """
    録画フォルダを検索し、各QUEの実行状況を表示する
    """
    b25list = glob.glob(path + "/*.b25")
    for b25f in b25list:
        ##b25f is title.ts.b25  avi is title.avi
        dir = os.path.split(b25f)[0]
        title = os.path.split(b25f)[1]
        title = title.replace(".ts.b25", "")
        avipath = os.path.join(dir, title + ".avi")
        tspath = os.path.join(dir, title + ".ts")
        b25f = b25f.replace(".ts.b25", ".avi")
        mode = "ts"
        if os.path.isfile(tspath):##tsファイルが存在している
            dtime = time.time()-os.path.getmtime(tspath)
            dtime = int(dtime)
            if dtime > 120:
                if os.path.getsize(tspath) > 1 * 1000 * 1000:##最終更新から22分以上経過かつ1MB以上
                    mode = "avi"
                else:
                    mode = "tsmiss"
            else:
                mode = "ts"
        if os.path.isfile(avipath):##tsファイルが存在している
            dtime = time.time()-os.path.getmtime(avipath)
            dtime = int(dtime)
            if dtime > 120:
                if os.path.getsize(avipath) > 1 * 1000 * 1000:##最終更新から22分以上経過かつ1MB以上
                    mode = "fin"
                else:
                    mode = "avimiss"
            else:
                mode = "avi"
        recdblist.printutf8(title + ":" + mode)

path = configreader.getpath("recpath")
search_b25(path)
